@extends('admin.layouts.master')
@section('title','Edit User')
@section('maincontent')
<?php
$data['heading'] = 'Edit User';
$data['title'] = 'Setting';
$data['title1'] = 'Mobile Setting';
?>
@include('admin.layouts.topbar',$data)
<div class="contentbar dashboard-card">
  <div class="row">
    @if ($errors->any())  
  <div class="alert alert-danger" role="alert">
  @foreach($errors->all() as $error)     
  <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
  <span aria-hidden="true" style="color:red;">&times;</span></button></p>
      @endforeach  
  </div>
  @endif
    <div class="col-lg-12">
      <div class="card dashboard-card m-b-30">
        <div class="card-header">
          <h5 class="box-title">{{ __('Edit User') }}</h5>
          <div class="widgetbar">
            <a href="{{ route('user.index') }}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Back') }}"><i
                class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a>
          </div>
        </div>
        <div class="card-body ml-2">
          <form action="{{ route('user.update',$user->id) }}" method="POST" enctype="multipart/form-data">
            {{ csrf_field() }}
            {{ method_field('PUT') }}
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Personal Details') }}</h4>
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="fname">
                      {{ __('First Name') }}:
                      <sup class="text-danger">*</sup>
                    </label>
                    <input value="{{ $user->fname }}" autofocus required name="fname" type="text" class="form-control"
                      placeholder="{{ __('Please Enter First Name') }}" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="lname">
                      {{ __('Last Name') }}:
                      <sup class="text-danger">*</sup>
                    </label>
                    <input value="{{ $user->lname }}" required name="lname" type="text" class="form-control"
                      placeholder="{{ __('Enter Last Name') }}" />
                  </div>
                </div>
                <div class="col-md-3">            
                  <div class="form-group">
                    <label for="mobile">{{ __('Email') }}:<sup class="text-danger">*</sup> </label>
                    <input value="{{ $user->email }}" required type="email" name="email"
                      placeholder="{{ __('Enter Email') }}"
                      class="form-control">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="mobile"> {{ __('Mobile') }}:</label>
                    <input value="{{ $user->mobile }}" type="text" name="mobile"
                      placeholder="{{ __('Enter Mobile') }}"
                      class="form-control">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="role">{{ __('Select Role') }}:</label>
                    @if(Auth::User()->role=="admin")
                    <select class="form-control select2" name="role" id="role-select">
                      <option value="">{{  __("Please select role") }}</option>
                      @foreach($roles as $role)
                      <option {{ $user->getRoleNames()->contains($role->name) ? 'selected' : "" }} value="{{ $role->name }}">{{ $role->name }}</option>
                      @endforeach
                    </select>
                    @endif
                    @if(Auth::User()->role=="instructor")
                    <select class="form-control select2" name="role">
                      <option {{ $user->role == 'user' ? 'selected' : ''}} value="user">{{ __('User') }}
                      </option>
                      <option {{ $user->role == 'instructor' ? 'selected' : ''}} value="instructor">
                        {{ __('Instructor') }}</option>
                    </select>
                    @endif
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label for="detail">{{ __('Detail') }}:<sup class="text-danger">*</sup></label>
                    <textarea id="detail" name="detail" class="form-control" rows="5"
                      placeholder="{{ __('Enter Detail') }}"
                      value="">{{ $user->detail }}</textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Address') }}</h4>
              <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="address">{{ __('Address') }}: </label>
                    <textarea name="address" class="form-control" rows="1"
                      placeholder="{{ __('Enter Adderss') }}" value="">{{ $user->address }}</textarea>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="country_id">{{ __('Country') }}: </label>
                    <select name="country_id" id="country_id" class="form-control select2">
                      <option value="">{{ __('Select Country') }}</option>
                      @foreach($countries as $country)
                        <option value="{{ $country->country_id }}" {{ (old('country_id', $user->country_id) == $country->country_id) ? 'selected' : '' }}>
                          {{ $country->name }}
                        </option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="state_id">{{ __('State') }}: </label>
                    <select name="state_id" id="state_id" class="form-control select2">
                      <option value="">{{ __('Select State') }}</option>
                      @foreach($states as $state)
                        <option value="{{ $state->state_id }}" {{ (old('state_id', $user->state_id) == $state->state_id) ? 'selected' : '' }}>
                          {{ $state->name }}
                        </option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="city_id">{{ __('City') }}: </label>
                    <select name="city_id" id="city_id" class="form-control select2">
                      <option value="">{{ __('Select City') }}</option>
                      @foreach($cities as $city)
                        <option value="{{ $city->id }}" {{ (old('city_id', $user->city_id) == $city->id) ? 'selected' : '' }}>
                          {{ $city->name }}
                        </option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label for="pin_code">{{ __('Pincode') }}:</label>
                    <input value="{{ $user->pin_code }}"
                      placeholder="{{ __('Enter Pincode') }}" type="text"
                      name="pin_code" class="form-control">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label class="text-dark" for="exampleInputSlug">{{ __('Image') }}: </label>
                    <small class="text-muted"><i class="fa fa-question-circle"></i>
                      {{ __('Recommended size') }} (410 x 410px)</small>
                    <div class="input-group mb-3">
                      <div class="input-group-prepend">
                        <span class="input-group-text" id="inputGroupFileAddon01">{{ __('Upload') }}</span>
                      </div>
                      <div class="custom-file">
                        <input type="file" name="user_img" class="custom-file-input" id="user_img_one" aria-describedby="inputGroupFileAddon01" onchange="readURL(this);">
                        <label class="custom-file-label" for="inputGroupFile01">{{ __('Choose file') }}</label>
                      </div>
                    </div>
                    <div class="thumbnail-img-block mb-3">
                      @if($user->user_img != null || $user->user_img !='')
                      <div class="edit-user-img">
                        <img src="{{ url('/images/user_img/'.$user->user_img) }}"  alt="User Image"  id="user_img" class="img-responsive image_size">
                      </div>
                      @else
                      <div class="edit-user-img">
                        <img src="{{ asset('images/default/user.jpg')}}"  alt="User Image"  id="user_img" class="img-responsive img-circle">
                      </div>
                      @endif                 
                    </div>   
                  </div>
                 </div>                
                </div>
              </div>
            <div class="bg-info-rgba p-4 mb-4">
              <h4 class="pb-4">{{ __('Social Profile') }}</h4>
            <div class="row">
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="fb_url">
                      {{ __('Facebook URL') }}:
                    </label>
                    <input autofocus name="fb_url" value="{{ $user->fb_url }}" type="text" class="form-control"
                      placeholder="Facebook.com/" />
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="youtube_url">
                      {{ __('YouTube URL') }}:
                    </label>
                    <input autofocus name="youtube_url" value="{{ $user->youtube_url }}" type="text" class="form-control"
                      placeholder="youtube.com/" />
                    </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="twitter_url">
                      {{ __('Twitter URL') }}:
                    </label>
                    <input autofocus name="twitter_url" value="{{ $user->twitter_url }}" type="text" class="form-control"
                      placeholder="Twitter.com/" />
                  </div>
                </div>
                <div class="col-md-3">
                   <div class="form-group">
                    <label for="linkedin_url">
                      {{ __('LinkedIn URL') }}:
                    </label>
                    <input autofocus name="linkedin_url" value="{{ $user->linkedin_url }}" type="text"
                      class="form-control" placeholder="Linkedin.com/" />
                  </div>
              </div>              
              <div class="col-md-4">
                  <div class="form-group">
                    <label for="exampleInputDetails">{{ __('Verified') }}:<sup class="redstar text-danger">*</sup></label><br>
                    <input id="verified" type="checkbox" class="custom_toggle" name="verified" {{  $user->email_verified_at != NULL ? 'checked' : '' }} />
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label for="exampleInputTit1e">{{ __('Status') }}:<sup
                        class="text-danger">*</sup></label><br>
                    <input type="checkbox" class="custom_toggle" name="status"
                      {{ $user->status == '1' ? 'checked' : '' }} />

                  </div>
              </div>
              <div class="col-md-4">                                
                <div class="form-group">                  

                  <div class="row">
                    <div class="col-md-12">
                      <div class="update-password">
                        <label for="box1"> {{ __('Update Password') }}:</label>
                        <br>
                        <input type="checkbox" id="myCheck" name="update_pass" class="custom_toggle" onclick="myFunction()">
                      </div>
                    </div>
                  </div>
                  <div style="display: none" id="update-password">
                  <div class="form-group">
                    <label>{{ __('Password') }} <sup class="text-danger">*</sup></label>
                    <input type="password" name="password" class="form-control"
                      placeholder="{{ __('Enter') }} {{ __('Password') }}">
                  </div>            
              
                <div class="form-group" >
                  <label>{{ __('Confirm Password') }} <sup class="text-danger">*</sup></label>
                  <input type="password" name="confirmpassword" class="form-control"
                    placeholder="{{ __('Confirm Password') }}">
                </div>
              </div>               
              </div>               
              </div>
            </div>
            </div>           
            <div class="form-group">
              <button type="reset" class="btn btn-danger-rgba" title="{{ __('Reset') }}"><i class="fa fa-ban"></i>
                {{ __('Reset') }}</button>
              <button type="submit" class="btn btn-primary-rgba" title="{{ __('Update') }}"><i class="fa fa-check-circle"></i>
                {{ __('Update') }}</button>
            </div>
            <div class="clear-both"></div>           
        </div>
      </div>
    </div>
  </div>
</div>
</div>
@endsection
@section('script')
<script>
  (function ($) {
    "use strict";

    $(function () {
      $("#dob,#doa").datepicker({
        changeYear: true,
        yearRange: "-100:+0",
        dateFormat: 'yy/mm/dd',
      });
    });
    $('#married_status').change(function () {

      if ($(this).val() == 'Married') {
        $('#doaboxxx').show();
      } else {
        $('#doaboxxx').hide();
      }
    });


    $(function () {
      var urlLike = '{{ url('
      country / gcity ') }}';
      $('#upload_id').change(function () {
        var up = $('#grand').empty();
        var cat_id = $(this).val();
        if (cat_id) {
          $.ajax({
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: "GET",
            url: urlLike,
            data: {
              catId: cat_id
            },
            success: function (data) {
              console.log(data);
              up.append('<option value="0">Please Choose</option>');
              $.each(data, function (id, title) {
                up.append($('<option>', {
                  value: id,
                  text: title
                }));
              });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
              console.log(XMLHttpRequest);
            }
          });
        }
      });
    });

  })(jQuery);

  

</script>


<script>
  (function($) {
    "use strict";
    $(function(){
        $('#myCheck').change(function(){
          if($('#myCheck').is(':checked')){
            $('#update-password').show('fast');
          }else{
            $('#update-password').hide('fast');
          }
        });
        
    });
  })(jQuery);
  </script>
<script>
  $(document).ready(function() {
      // Initialize select2
      $('.select2').select2();
      
      // Country change event
      $('#country_id').on('change', function() {
          var countryId = $(this).val();
          $('#state_id').empty().append('<option value="">Select State</option>');
          $('#city_id').empty().append('<option value="">Select City</option>');
          
          if(countryId) {
              $.ajax({
                  url: '{{ route("get.states") }}',
                  type: 'GET',
                  data: { country_id: countryId },
                  success: function(data) {
                      $.each(data, function(key, value) {
                          $('#state_id').append('<option value="'+ value.state_id +'">'+ value.name +'</option>');
                      });
                  }
              });
          }
      });
      
      // State change event
      $('#state_id').on('change', function() {
          var stateId = $(this).val();
          $('#city_id').empty().append('<option value="">Select City</option>');
          
          if(stateId) {
              $.ajax({
                  url: '{{ route("get.cities") }}',
                  type: 'GET',
                  data: { state_id: stateId },
                  success: function(data) {
                      $.each(data, function(key, value) {
                          $('#city_id').append('<option value="'+ value.id +'">'+ value.name +'</option>');
                      });
                  }
              });
          }
      });
  });
  </script>
  <script src="{{ asset('admin_assets/js/sweetalert2.all.min.js') }}"></script>
  <script>
     $(document).ready(function() {
    const roleSelect = $('#role-select');
    const originalRole = roleSelect.val();
    
    roleSelect.on('change', function() {
        if (this.value !== originalRole && this.value !== "") {
            Swal.fire({
                title: "Warning",
                text: "Changing the user role will permanently alter permissions...",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Continue',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (!result.isConfirmed) {
                    roleSelect.val(originalRole);
                }
            });
        }
    });
});
  </script>
@endsection